#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_HL7ClientConnection : BaseTest
	{
		private static HL7Interface _intParms;
		private static HL7ClientConnection _client;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_intParms = new HL7Interface("CPRS");

		}
		[TearDown]
		protected void TearDown()
		{
		}

		[Test]
		public void Constructor_Pass()
		{
			_client = new HL7ClientConnection(_intParms);
			Assert.IsNotNull(_client);
			_client.Dispose();
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Constructor_Fail()
		{
			_client = new HL7ClientConnection(null);
			_client.Dispose();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Connect_Pass()
		{
			// This method requires a valid VistA system to connect to and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Connect_Fail()
		{
			// This method requires a valid VistA system to connect to and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void SendReceiveMessage_Pass()
		{
			// This method required a valid current CPRS message and is not testable
			// through unit testing.
			// This method is tested indirectly by other methods.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void SendReceiveMessage_Fail()
		{
			// This method requires a valid VistA system to connect to and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Dispose_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Dispose_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Close_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Close_Fail()
		{
		}

		[Test]
		public void InterfaceConnectionInfo_Pass()
		{
			_client = new HL7ClientConnection(_intParms);
			Assert.AreSame(_client.InterfaceConnectionInfo,_intParms);
			_client.Dispose();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InterfaceConnectionInfo_Fail()
		{}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void IsConnected_Pass()
		{
			// This method requires a valid VistA system to connect to and is not tesTABLES.
			// This method is tested indirectly through other methods.
		}

		[Test]
		public void IsConnected_Fail()
		{
			_client = new HL7ClientConnection(_intParms);
			Assert.IsTrue(!_client.IsConnected);
		}

	}
}
#endif
